/*jslint node: true, nomen: true, unparam: true */
/*global jquery, _, $, define, navigator, window */

/* on panelcreate, move left-side panels to before the page content 
 * right-side panels to after the page conteint in the DOM order */
'use strict';
define([ 'jquery', 'Portal' ], function ($, Portal) {
    return (function () {
        var _accessiblePanel = {};

        _accessiblePanel.register = function register() {
            // after a panel is created and in the DOM,
            // adjust DOM order (should move rather than clone)
            $(document).on('panelcreate', function (e) {
                var $panel = $(e.target),
                    position = $panel.panel('option', 'position');

                var regions = $panel.parent('.ui-page').children(":not('.ui-popup-screen, .ui-popup-container')"),
                    $contentWrapper = regions.filter( '.ui-panel-content-wrap' ),
                    panelIndex = regions.filter( e.target ).index(),
                    // assuming infobarRegion is immediately before infobarSubRegion
                    infobarSubRegionIndex = regions.filter( Portal.infobarSubRegion.el ).index(),
                    containerRegionIndex = $contentWrapper.index(),
                    infobarFooterRegionIndex = regions.filter( Portal.infobarFooterRegion.el ).index();

                if ( position === "left" && (panelIndex < infobarSubRegionIndex || panelIndex > containerRegionIndex) ) {
                    $contentWrapper.before($panel);
                } else if ( (position === "right") && (panelIndex > infobarFooterRegionIndex || panelIndex < containerRegionIndex) ) {
                    $contentWrapper.after($panel);
                }
            });
        };

        return _accessiblePanel;
    }());
});